#!/bin/sh

jq="./jq-win64.exe"

#日志输入
log() {
   case $2 in
   "success")
      echo -e "\e[1;32m $1 \e[0m"
      ;;
   "info")
      echo -e "\e[1;37m $1 \e[0m"
      ;;
   "warning")
      echo -e "\e[1;33m $1 \e[0m"
      ;;
   "error")
      echo -e "\e[1;31m $1 \e[0m"
      ;;
   *)
      echo -e "\e[1;37m $1 \e[0m"
      ;;
   esac
}

#获取当前分支名称
get_current_branch() {
  branch=''
  
  # 尝试使用git symbolic-ref HEAD获取 
  branch=$(git symbolic-ref HEAD | sed -e 's/^refs\/heads\/\(.*\)$/\1/')
  
  # 若失败,尝试git rev-parse --abbrev-ref HEAD
  if [ -z "$branch" ]; then
    branch=$(git rev-parse --abbrev-ref HEAD) 
  fi 
  
  # 若还失败,使用git branch提取带*号的当前分支  
  if [ -z "$branch" ]; then
    branch=$(git branch | sed -n '/^.*/s/^\* \(.*\)/\1/p')
  fi
  
  echo $branch
}

#通过账号获取token
getToken() {

   token=($(curl -X POST "https://testapi.gzsle.com/auth/user/login" \
   -H "Content-Type: application/json" \
   -d '{"user_name":"wangyan", "password":"gzsle888", "login_type":2}'\
   --compressed | awk -F'"authorization":"' '{print $2}' | awk -F '"},' '{print $1}'))

   echo $token

}

#获取所有在线用户的userId
getUserId() {

   URL="https://testapi.gzsle.com/auth/user/getAuthUsersList?role_id=101&biz_type=1&page_no=1&page_size=500"

   response=$(curl -s -H "Authorization: Bearer $1" "$URL")

   echo "$response" | $jq  .data.user_base_info_list.[].id | $jq -s 'map(tostring)|map("test_" + .)' -c

}

#发送消息通知
jPush() {
       
  echo $(curl -s "https://api.jpush.cn/v3/push" \
  -H "Authorization: Basic YjhiNjcyZmY3MjkyNjM1MTkzZjFhNjgwOmJmYWExYTg3YTEwZTNlMTJjNTI0ZmI0OQ==" \
  -H "Content-Type: text/plain;charset=UTF-8" \
  -d '{"platform":["android", "ios"],"audience":{"alias":'$1'},"message":{"title":"Update","msg_content":"Update"}}' \
  --compressed)

}

#发送消息通知
jPushMessage() {
       
  echo $(curl -s "https://api.jpush.cn/v3/push" \
  -H "Authorization: Basic YjhiNjcyZmY3MjkyNjM1MTkzZjFhNjgwOmJmYWExYTg3YTEwZTNlMTJjNTI0ZmI0OQ==" \
  -H "Content-Type: text/plain;charset=UTF-8" \
  -d '{"platform":["ios"],"inapp_message":{"inapp_message":false},"options":{"classification":0,"time_to_live":86400,"apns_production":false,"sendno":1741686107},"notification":{"alert":"565656asdas萨达","ios":{"alert":{"title":"6565啊实打实","body":"565656asdas萨达"},"content-available":0,"mutable-content":true,"sound":"default","badge":"+1","thread-id":"","interruption-level":"active","filter-criteria":"","extras":{}}},"audience":{"alias":["test_84191"]}}' \
  --compressed)

}

main() {

   jPushMessage

   # DART_DEFINES=$(getToken)

   # USERLIST=$(getUserId $DART_DEFINES)

   # jPushMessage $USERLIST
   
   # echo "$USERLIST" 2>&1 | tee curl.log

   # current_branch=$(get_current_branch)

   # echo $current_branch

   # if [[ "${current_branch}" == "test" ]]; then
   #    jPush
   # else
   #    echo "发送通知"
   # fi
}


main
